import { View, FlatList } from "react-native";
import React from "react";
import FeatureCategories from "./FeatureCategories/FeatureCategories";
import { homeStyle } from "./homeStyle";
import HomeBanner from "./HomeBanner/HomeBanner";
import FeaturedProducts from "./FeaturedProducts/FeaturedProducts";
import MenuNavigation from "../Utilities/CustomHeader/MenuNavigation";
import Feature from "./Feature/Feature";
import { useDispatch } from "react-redux";
import { getHomeBanner } from "../../redux/slices/homeBanner/homeBanner";
import { getTopCategory } from "../../redux/slices/categorys/topCategory";
import { getFeatureProducts } from "../../redux/slices/featureProducts/featureProducts";
import SearchInput from "../../src/components/CustomInput/SearchInput/SearchInput";
import { getPreferences } from "../../redux/slices/preferences/getPreferences";

import { BASE_API_URL_STG } from "@env";
import useLangTranslation from "../../hooks/useLangTranslation";

const Home = (props) => {
    const { trans } = useLangTranslation();
    const dispatch = useDispatch();
    const URL = `${BASE_API_URL_STG}/user/products`;

    console.log(URL);

    const handlePullToRefresh = async () => {
        dispatch(getHomeBanner());
        dispatch(getTopCategory());
        dispatch(getFeatureProducts(URL));
        dispatch(getPreferences());
    };

    return (
        <View>
            <MenuNavigation navigationProps={props.navigation} routeName={""} />
            <SearchInput props={props} />
            <View style={homeStyle.body}>
                <FlatList
                    listKey={(_, i) => "m" + i.toString()}
                    showsVerticalScrollIndicator={false}
                    ListHeaderComponent={() => (
                        <>
                            <HomeBanner />
                            <Feature />
                            <FeatureCategories headerText={trans("Top Categories")} />
                            <FeaturedProducts />
                        </>
                    )}
                    onRefresh={handlePullToRefresh}
                    refreshing={false}
                />
            </View>
        </View>
    );
};

export default Home;
